//slim raytracer

#include "slim.h"
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <signal.h>
#include "common/debug.h"
#include "common/structs.h"
#include "render/intersect/intersect.h"
#include "load/load.h"
#include "misc/save_frame.h"
#include "frontend/front_init.h"
#include "frontend/display_scene.h"
#include "shader/shaders.h"
#include "simulation/simulation.h"
#include "render/intersect/sphere.h"

int render(void);
void render_frame(void);
void setup_default_scene();

//current scene
scene_data mscene;
scene_data *main_scene = &mscene;

//current system state
system_data sys_state;
system_data *sys = &sys_state;

int intersects_calced = 0;
int DEBUG_LEVEL = 0;
void (*print_function)(char*, va_list);
void (*print_frame_data)(char*, va_list);
int interpolate_on = 1;
clock_t current_time;
extern int sim_type;

void catch_sigint()
{
	printd(QUIET, "Caught SIGINT. Exiting.\n");
	exit(1);
}

#define MAX_POST_SHADERS 20
void setup_default_system()
{
	sys->max_num_threads = 1;
	sys->debug_level = NORMAL;
	sys->max_height = 100;
	sys->max_width = 100;
	
	//add post shaders
//	list_make(&sys->post_shaders, MAX_POST_SHADERS);
//	list_add_item(&sys->post_shaders, (void*)get_invert(), "invert");
	
	list_make(&sys->active_post_shaders, MAX_POST_SHADERS);
	//list_add_item(&sys->active_post_shaders, list_get_name(&sys->post_shaders,"invert"), NULL);
}

int main(int argc, char** argv)
{
	print_function = print_to_stdout;
	print_frame_data = print_to_stdout;

	#ifndef WIN32
// 	signal(SIGINT, catch_sigint);
	#endif

	setup_default_system();
	setup_default_scene();

	// initial configuaration
	srand((unsigned) time(NULL));
	DEBUG_LEVEL = sys->debug_level;
	setup_intersect();
	setup_shaders();

	// load scene data
	init_scene(argc, argv, main_scene);
	
	//pqp_setup();
	//reset_sim();
	if(sim_type == T_BALLS)
		setup_rects();
	else if(sim_type == T_BEAD)
		setup_sim();
	// render the scene

	render();

	return 0;
}

void setup_default_scene()
{
	main_scene->width = 200;
	main_scene->height = 200;
	
	main_scene->camera = (camera_data*) malloc( sizeof(camera_data));
	set_tri(&main_scene->camera->pos, 0, 0, 0);
	set_tri(&main_scene->camera->rot, 0, 0, 0);
	set_tri(&main_scene->camera->look, 0, 0, 0);
	set_tri(&main_scene->camera->lookP, 0, 0, 0);
	set_tri(&main_scene->camera->up, 0, 0, 0);
	main_scene->camera->units = 0;
	
	main_scene->width = 200;
	main_scene->height = 200;
	main_scene->max_recurs = 1;
	main_scene->sub_dis = 1;
	main_scene->antialiasing = 0;
	main_scene->sub_var = 1;
	main_scene->sub_level = 1;
}

int render()
{
	//render_frame();
	//generate_subs();
	//generate_srays();
	//normal_sampler();
	//deferred_renderer();
	//save_frame(main_scene);
	frontend_init();
	display_scene();

	return 1;
}
